/*----------------------------------------------------------------------------
 * Name:    ble process.h
 * Purpose: ble process definitions
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#ifndef _BLE_PROCESS_H_
#define _BLE_PROCESS_H_

#include "ht32f5xxxx_01.h"
#include	"ble.h"

// <<< Use Configuration Wizard in Context Menu >>>

//	<h> Hardware Default UART Baud Rate
// 	<o> Baud Rate
//    	<0=> 9600bps
//       <5=> 115200bps
#define _UART_BAUDRATE_  (5)
//	</h>

// <e> Fixed UART Baud Rate Enable
#define	_FIXED_BAUD_RATE_ENABLE_	(0)
// 	<o> Baud Rate
//    	<0=> 9600bps
//       <1=> 14400bps
//    	<2=> 19200bps
//       <3=> 38400bps
//       <4=> 57600bps
//       <5=> 115200bps
#define _FIXED_BAUDRATE_  (6)
// </e>

// <e> Change UART Baud Rate Enable
#define	_CHG_BAUD_RATE_ENABLE_	(1)
// 	<o> Baud Rate
//    	<0=> 9600bps
//       <1=> 14400bps
//    	<2=> 19200bps
//       <3=> 38400bps
//       <4=> 57600bps
//       <5=> 115200bps
#define _CHANGE_BAUDRATE_  (5)
// </e>

//	<e> External 32.768KHZ Crystal Configure Enable
#define	_EXTERNAL32_CFG_ENABLE_   (0)
//	</e>

// <e> Crystal C-Load Configure Enable
#define	_CLOAD_CFG_ENABLE_   (1)
//		<o> Crystal C-Load<0-15>
#define 	_CLOAD_VALUE_  (4)
// </e>

//	<e> Tx Power Configure Enable
#define	_TXPWR_CFG_ENABLE_   (1)
//		<o> Tx Power<0-15>
#define 	_TX_POWER_VALUE_  (15)
//	</e>

//	<e> BT Device Name Configure Enable
#define	_BDNAME_CFG_ENABLE_   (1)
//	</e>

//	<e> Advertising data Configure Enable
#define	_ADV_DATA_CFG_ENABLE_   (1)
//	</e>

//	<e> Scan Response Data Configure Enable
#define	_SCAN_DATA_CFG_ENABLE_   (1)
//	</e>

//	<e> Device Information Configure Enable
#define	_DEV_INF_CFG_ENABLE_   (1)
//	</e>

//	<e> Advertising interval Configure Enable
#define	_ADV_INTV_CFG_ENABLE_   (1)
//		<o> Min Interval(ms)<10-40000>
#define 	_ADV_INTV_MIN_VALUE_  	(100)
//		<o> Max Interval(ms)<10-40000>
#define 	_ADV_INTV_MAX_VALUE_  	(100)
//	</e>

//	<e> Save S/W parameters Enable
#define	_SAVE_SW_PARA_ENABLE_   (0)
//	</e>

/* BLE operate parameter define */
typedef struct __attribute__((packed))
{
	u8		DateCode[6];
	tDEV_ADDR	BDAddr;
	u8		States;
	bool	ConnectState;
	u16	TimeCounter;
}tBLE_OPERATE;

/* event response operate parameter define */
typedef struct __attribute__((packed))
{
	u8		flag;
	u8		RspType;
	u8		RspFlag;
	u16	RspOpCode;
	u16	TimeCounter;
}tEVENT_RESPONSE;

#define	EVENT_RSP_UNDONE		0x00
#define	EVENT_RSP_DONE			0x01
#define	EVENT_RSP_ERROR		0x02
#define	EVENT_RSP_TMOUT		0x80

#define	RESET_DELAY_TIME		8			/* reset pin low time */
#define	PWRUP_DELAY_TIME		60			/* ble hardware reset delay time(ms) */
#define	BOOT_READY_TIME		8			/* ble boot ready delay time(ms) */
#define  EVENT_RETURN_TIME    250  		/* 250ms */
#define	CHG_BAUD_DELAY_TIME	2
#define	RF_CALIBRAT_TIME		600		/* 600ms */
#define	DTM_CALIBRAT_TIME		800		/* 800ms */
#define	EVENT_RSP_EMPTY		0x0E0E   /* no event response */
#define	EVENT_RSP_TIMEOUT		0x0E

enum
{
   _BLE_START_ 				= 0x00,
   _BLE_POWER_UP_ 			= 0x10,
   _BLE_RESET_DELAY_,
   _BLE_PWRUP_DELAY_,
   _BLE_BOOT_READY_,
	_BLE_PWRUP_EXAMINE_,
	_BLE_RECORD_DATECODE_,
	_BLE_RECORD_BDADDR_,
	_BLE_CHG_BAUD_RATE_		= 0x20,
	_BLE_CHG_UART_BAUD_,
	_BLE_PARAMETER_MODIFY,
	_BLE_SERVICE_MODIFY,
	_BLE_BAUDRATE_CHANGE_ 	= 0x30,
	_BLE_BAUDRATE_FINISH_,
	_BLE_FEATURE_SETUP_		= 0x80,
	_BLE_ADV_ENABLE_			= 0x90,
	_BLE_ADV_DELAY_S_,
	_BLE_ADV_DELAY_E_,
	_BLE_EVENT_RESPONSE_ 	= 0xAC,
	_BLE_PWR_ON_FINISH_ 		= 0xE0,
	_BLE_PWR_ON_SUCCESS_		= 0xEA,
	_BLE_POWER_DOWN_ 			= 0xFD,
   _BLE_PWR_ON_ERROR_ 		= 0xFF
};

extern tBLE_OPERATE BLE_Operate;

void BLE_ParameterInitial(void);
bool BLE_Transceive(void *pack,u16 timeout);
bool BLE_EventResponseEmpty(void);
void BLE_TimerProcess(void);
void *BLE_Process(void);



#endif	/* _BLE_PROCESS_H_ */
